<?php
ob_start();
error_reporting(E_ALL);
$strNo = rand(1, 1000000);
date_default_timezone_set('Asia/Calcutta');
$base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
//echo '<pre>';print nl2br(print_r($_REQUEST, true));echo '</pre>';exit;

$strCurDate = date('Y-m-d');
$bankCode = '470';
$custID = '19872627';
$locatorURL = 'https://www.tpsl-india.in/PaymentGateway/TransactionDetailsNew.wsdl';
require_once 'TransactionRequestBean.php';

$parameters = file_get_contents("./parameters.json");
$data = json_decode($parameters, true);

$protocolType = 'http';
if (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') {
    $protocolType = 'https';
}

if(!empty($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == '80'){
    $hostStr = "$protocolType://$_SERVER[SERVER_NAME]$_SERVER[SCRIPT_NAME]";
}else{
    $hostStr = "$protocolType://$_SERVER[SERVER_NAME]:$_SERVER[SERVER_PORT]$_SERVER[SCRIPT_NAME]";
}
$resHost = explode('/', $hostStr);
array_pop($resHost);
$resHostNew = $resHost;
array_push($resHost, 'response.php');
$resUrl = implode('/', $resHost);

if ($_REQUEST && isset($_REQUEST['amount'])) {
    $val = $_REQUEST;
    
    $val['amount'] = 1;
    $amount = number_format((float)$val['amount'], 2,'.','');
    $scheme_code = $data['schemeCode']."_".$amount."_0.0";
    
    $transactionRequestBean = new TransactionRequestBean();
    //Setting all values here
    $transactionRequestBean->merchantCode = $data['merchantCode'];
    $transactionRequestBean->ITC = 'email:'.$val['email'];
    $transactionRequestBean->customerName = $val['name'];
    $transactionRequestBean->email = $val['email'];
    $transactionRequestBean->requestType = 'T';
    $transactionRequestBean->merchantTxnRefNumber = $val['mrctTxtID'];
    $transactionRequestBean->amount = $amount;
    $transactionRequestBean->currencyCode = 'INR';
    $transactionRequestBean->returnURL = $base_url.':443/pg/worldline/response.php';
    $transactionRequestBean->shoppingCartDetails = $scheme_code;
    $transactionRequestBean->mobileNumber = $val['mobile'];
    $transactionRequestBean->txnDate = $strCurDate;
    $transactionRequestBean->bankCode = $bankCode;
    $transactionRequestBean->custId = $custID;
    $transactionRequestBean->key = $data['key'];
    $transactionRequestBean->iv = $data['iv'];
    $transactionRequestBean->accountNo = $val['accNo'];
    $transactionRequestBean->webServiceLocator = $locatorURL;
    $transactionRequestBean->timeOut = (!empty($val['timeOut']) ? $val['timeOut'] : 30);
    //echo '<pre>';print nl2br(print_r($transactionRequestBean, true));echo '</pre>';exit;
    
    //Writing in Request Log
    $log  = "Name : ".$transactionRequestBean->customerName."; Date : ".date("F j, Y, g:i a")."; Request Data : ".$transactionRequestBean->merchantCode."|".$transactionRequestBean->ITC."|".$transactionRequestBean->customerName."|".$transactionRequestBean->requestType."|".$transactionRequestBean->merchantTxnRefNumber."|".$transactionRequestBean->amount."|".$transactionRequestBean->currencyCode."|".$transactionRequestBean->returnURL."|".$transactionRequestBean->shoppingCartDetails."|".$transactionRequestBean->TPSLTxnID."|".$transactionRequestBean->mobileNumber."|".$transactionRequestBean->txnDate."|".$transactionRequestBean->bankCode."|".$transactionRequestBean->custId."|".$transactionRequestBean->key."|".$transactionRequestBean->iv."|".$transactionRequestBean->accountNo."|".$transactionRequestBean->webServiceLocator.PHP_EOL;
    
    //Saving string to log by using "FILE_APPEND" to append.
    file_put_contents('logs/request/log_'.date("j.n.Y").'.log', $log, FILE_APPEND);

    $responseDetails = $transactionRequestBean->getTransactionToken();
    $responseDetails = (array)$responseDetails;
    $response = $responseDetails[0];
    echo "<script>window.location = '" . $response . "'</script>";
    ob_flush();
}
$resHostNew =  implode('/', $resHostNew);
?>

